#!/usr/bin/python
# Autor: Frane Kurtovic

import sys

MAX_POWER = 100

class polinom:
    def __init__(self, koefs=None):
        if koefs == None:
            koefs = [0] * (MAX_POWER+1)
        assert len(koefs) == MAX_POWER+1
        self.koefs = list(koefs)

    def __str__(self):
        ret = []
        for p, k in enumerate(self.koefs):
            if k == 0:
                continue
            if k > 1 and p > 1:
                str_format = "{}x^{}".format(k,p)
            elif k == 1 and p > 1:
                str_format = "x^{}".format(p)
            elif k > 1 and p == 1:
                str_format = "{}x".format(k)
            else:
                str_format = "x"
            ret.append(str_format)
        ret.reverse()
        return '+'.join(ret)

    def __add__(self, rhs):
        ret = []
        for l, r in zip(self.koefs, rhs.koefs):
            ret.append(l+r)
        return polinom(ret)

    def __mul__(self, rhs):
        ret = [0] * (MAX_POWER+1)
        for p1, k1 in enumerate(self.koefs):
            for p2, k2 in enumerate(rhs.koefs):
                assert not(p1+p2 > MAX_POWER and k1*k2 > 0), \
                       'Polinom veci od 100'
                if p1+p2 > MAX_POWER:
                    continue
                ret[p1+p2] += k1*k2
        return polinom(ret)


def main():
    n = input()

    d = [polinom() for _ in xrange(10)]
    d[0].koefs[1] = 1
    for line in sys.stdin.readlines():
        n -= 1
        line = line.strip()
        cmd, da, db = line.split()
        assert da[0] == 'd' and db[0] == 'd', 'Nisu dobri razmaci'
        assert cmd == 'add' or cmd == 'mul', 'Cmd nije dobar'
        da, db = int(da[1:]), int(db[1:])
        if cmd == 'add':
            d[da] = d[da] + d[db]
        else:
            d[da] = d[da] * d[db]
    print d[0]
    assert n == 0, 'Broj naredbi nije dobar'

if __name__ == "__main__":
    main()
